/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp.test;

import filenet.vw.api.VWFieldType;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.exprcomp.IField;

public class TestFieldImpl
implements IField {
    protected String name = null;
    protected Object value = null;
    protected int fieldType;
    protected boolean isArray;

    protected TestFieldImpl() {
    }

    public TestFieldImpl(String theName, int theType, boolean theIsArray, Object theValue) throws Exception {
        if (theName == null || theName.length() == 0) {
            throw new Exception("null or empty field name");
        }
        if (!VWFieldType.isValid(theType)) {
            throw new Exception("Invalid field type " + String.valueOf(theType));
        }
        this.name = theName;
        this.fieldType = theType;
        this.isArray = theIsArray;
        this.setValue(theValue);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public Object getValue() throws Exception {
        return this.value;
    }

    public void setValue(Object theValue) throws Exception {
        if (theValue == null) {
            throw new Exception("Parameter theValue is null.");
        }
        if (theValue.getClass().isArray() != this.isArray) {
            throw new Exception("Parameter theValue, isArray mismatch.");
        }
        if (VWFieldType.getVWFieldType(theValue) != this.fieldType) {
            throw new Exception("Parameter theValue's type," + this.value.getClass().toString() + ", doesn't match the field's declared type, " + VWFieldType.getLocalizedString(this.fieldType) + ".");
        }
        this.value = theValue;
    }

    public String getName() throws Exception {
        return this.name;
    }

    public String toString() {
        try {
            if (!this.isArray) {
                return this.name + " : " + VWFieldType.getLocalizedString(this.fieldType) + " : <" + this.value.toString() + ">";
            }
            return this.name + " : " + VWFieldType.getLocalizedString(this.fieldType) + "[]";
        }
        catch (Exception e) {
            return "MyFieldImpl.toString(), error making string from field";
        }
    }

    public CEObjectInfo getCEObjectInfo() {
        return null;
    }
}

